console['log']('[Popup]\x20当前扩展ID:', chrome['runtime']['id']);
async function getCurrentTab() {
    return new Promise(a => {
        chrome['tabs']['query']({
            'active': !![],
            'currentWindow': !![]
        }, b => {
            a(b[0x0]);
        });
    });
}
async function ensureContentScript(a) {
    return new Promise(b => {
        chrome['scripting']['executeScript']({
            'target': { 'tabId': a },
            'files': ['content.js']
        }, b);
    });
}
async function sendMessageToContentScript(a) {
    const b = await getCurrentTab();
    if (!b['url'] || !b['url']['startsWith']('https://')) {
        setStatus(t('ui.status.notHttps'));
        throw new Error('Not\x20on\x20supported\x20site');
    }
    const c = new URL(b['url']);
    try {
        await ensureContentScript(b['id']);
        const d = await new Promise(e => {
            chrome['tabs']['sendMessage'](b['id'], { 'type': 'testApiEndpoint' }, e);
        });
        if (!d || !d['success']) {
            setStatus(t('ui.status.mayNotSupport', { 'hostname': c['hostname'] }));
            throw new Error('API\x20endpoint\x20not\x20available');
        }
    } catch (e) {
        console['error']('Domain\x20validation\x20or\x20API\x20test\x20failed:', e);
        e['message']['includes']('Domain') ? setStatus(t('ui.status.unauthorizedDomain', { 'hostname': c['hostname'] })) : setStatus(t('ui.status.unsupportedSite', { 'hostname': c['hostname'] }));
        throw e;
    }
    return await ensureContentScript(b['id']), new Promise((f, g) => {
        chrome['tabs']['sendMessage'](b['id'], a, h => {
            chrome['runtime']['lastError'] ? g(new Error(chrome['runtime']['lastError']['message'])) : f(h);
        });
    });
}
async function fetchConversationsList() {
    const a = await sendMessageToContentScript({ 'type': 'getConversationsList' });
    if (a && a['success'])
        return a['data']['items'];
    else
        throw new Error(a ? a['error'] : '未知错误');
}
async function fetchConversationDetail(a) {
    const b = await sendMessageToContentScript({
        'type': 'getConversationDetail',
        'id': a
    });
    if (b && b['success'])
        return b['data'];
    else
        throw new Error(b ? b['error'] : '未知错误');
}
function formatAsHTML(a) {
    const b = i18n['getCurrentLocale'](), c = new Date()['toLocaleString'](b === 'zh-CN' ? 'zh-CN' : b === 'zh-TW' ? 'zh-TW' : 'en-US'), d = b === 'zh-TW' ? 'zh-TW' : b === 'zh-CN' ? 'zh-CN' : 'en';
    let e = '<!DOCTYPE\x20html>\x0a<html\x20lang=\x22' + d + '\x22>\x0a<head>\x0a\x20\x20\x20\x20<meta\x20charset=\x22UTF-8\x22>\x0a\x20\x20\x20\x20<meta\x20name=\x22viewport\x22\x20content=\x22width=device-width,\x20initial-scale=1.0\x22>\x0a\x20\x20\x20\x20<title>' + t('export.html.title') + '\x20-\x20' + c + '</title>\x0a\x20\x20\x20\x20<style>\x0a\x20\x20\x20\x20\x20\x20\x20\x20body\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20font-family:\x20-apple-system,\x20BlinkMacSystemFont,\x20\x27Segoe\x20UI\x27,\x20Roboto,\x20sans-serif;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20line-height:\x201.6;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20max-width:\x201200px;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20margin:\x200\x20auto;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20padding:\x2020px;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20background:\x20#f8fafc;\x0a\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x20\x20\x20\x20\x20\x20\x20\x20.header\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20background:\x20linear-gradient(135deg,\x20#4f46e5\x200%,\x20#7c3aed\x20100%);\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20color:\x20white;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20padding:\x2030px;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20border-radius:\x2012px;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20text-align:\x20center;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20margin-bottom:\x2030px;\x0a\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x20\x20\x20\x20\x20\x20\x20\x20.conversation\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20background:\x20white;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20border-radius:\x2012px;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20padding:\x2024px;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20margin-bottom:\x2024px;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20box-shadow:\x200\x204px\x206px\x20rgba(0,\x200,\x200,\x200.1);\x0a\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x20\x20\x20\x20\x20\x20\x20\x20.conversation-header\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20border-bottom:\x202px\x20solid\x20#e5e7eb;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20padding-bottom:\x2016px;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20margin-bottom:\x2020px;\x0a\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x20\x20\x20\x20\x20\x20\x20\x20.conversation-title\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20font-size:\x2024px;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20font-weight:\x20600;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20color:\x20#1f2937;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20margin-bottom:\x208px;\x0a\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x20\x20\x20\x20\x20\x20\x20\x20.conversation-id\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20font-family:\x20\x27SF\x20Mono\x27,\x20Monaco,\x20monospace;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20font-size:\x2014px;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20color:\x20#6b7280;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20background:\x20#f3f4f6;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20padding:\x204px\x208px;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20border-radius:\x204px;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20display:\x20inline-block;\x0a\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x20\x20\x20\x20\x20\x20\x20\x20.message\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20margin-bottom:\x2020px;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20padding:\x2016px;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20border-radius:\x208px;\x0a\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x20\x20\x20\x20\x20\x20\x20\x20.message.user\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20background:\x20#eff6ff;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20border-left:\x204px\x20solid\x20#3b82f6;\x0a\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x20\x20\x20\x20\x20\x20\x20\x20.message.assistant\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20background:\x20#f0fdf4;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20border-left:\x204px\x20solid\x20#10b981;\x0a\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x20\x20\x20\x20\x20\x20\x20\x20.message-role\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20font-weight:\x20600;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20margin-bottom:\x208px;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20text-transform:\x20uppercase;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20font-size:\x2012px;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20letter-spacing:\x200.5px;\x0a\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x20\x20\x20\x20\x20\x20\x20\x20.message.user\x20.message-role\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20color:\x20#1d4ed8;\x0a\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x20\x20\x20\x20\x20\x20\x20\x20.message.assistant\x20.message-role\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20color:\x20#059669;\x0a\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x20\x20\x20\x20\x20\x20\x20\x20.message-content\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20white-space:\x20pre-wrap;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20word-wrap:\x20break-word;\x0a\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x20\x20\x20\x20\x20\x20\x20\x20.toc\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20background:\x20white;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20border-radius:\x2012px;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20padding:\x2024px;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20margin-bottom:\x2030px;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20box-shadow:\x200\x204px\x206px\x20rgba(0,\x200,\x200,\x200.1);\x0a\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x20\x20\x20\x20\x20\x20\x20\x20.toc\x20h2\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20margin-top:\x200;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20color:\x20#1f2937;\x0a\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x20\x20\x20\x20\x20\x20\x20\x20.toc\x20ul\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20list-style:\x20none;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20padding:\x200;\x0a\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x20\x20\x20\x20\x20\x20\x20\x20.toc\x20li\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20margin-bottom:\x208px;\x0a\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x20\x20\x20\x20\x20\x20\x20\x20.toc\x20a\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20color:\x20#3b82f6;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20text-decoration:\x20none;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20padding:\x208px\x2012px;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20border-radius:\x206px;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20display:\x20block;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20transition:\x20background\x200.2s;\x0a\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x20\x20\x20\x20\x20\x20\x20\x20.toc\x20a:hover\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20background:\x20#eff6ff;\x0a\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x20\x20\x20\x20</style>\x0a</head>\x0a<body>\x0a\x20\x20\x20\x20<div\x20class=\x22header\x22>\x0a\x20\x20\x20\x20\x20\x20\x20\x20<h1>' + t('export.html.title') + '</h1>\x0a\x20\x20\x20\x20\x20\x20\x20\x20<p>' + t('export.html.exportTime', { 'time': c }) + '</p>\x0a\x20\x20\x20\x20\x20\x20\x20\x20<p>' + t('export.html.conversationCount', { 'count': a['length'] }) + '</p>\x0a\x20\x20\x20\x20</div>';
    return a['length'] > 0x1 && (e += '\x0a\x20\x20\x20\x20<div\x20class=\x22toc\x22>\x0a\x20\x20\x20\x20\x20\x20\x20\x20<h2>' + t('export.html.tableOfContents') + '</h2>\x0a\x20\x20\x20\x20\x20\x20\x20\x20<ul>', a['forEach']((f, g) => {
        const h = f['title'] || t('ui.messages.noTitle');
        e += '<li><a\x20href=\x22#conv-' + g + '\x22>' + h + '</a></li>';
    }), e += '\x0a\x20\x20\x20\x20\x20\x20\x20\x20</ul>\x0a\x20\x20\x20\x20</div>'), a['forEach']((f, g) => {
        const h = f['title'] || t('ui.messages.noTitle');
        e += '\x0a\x20\x20\x20\x20<div\x20class=\x22conversation\x22\x20id=\x22conv-' + g + '\x22>\x0a\x20\x20\x20\x20\x20\x20\x20\x20<div\x20class=\x22conversation-header\x22>\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20<div\x20class=\x22conversation-title\x22>' + h + '</div>\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20<div\x20class=\x22conversation-id\x22>' + t('export.html.conversationId', { 'id': f['conversation_id'] }) + '</div>\x0a\x20\x20\x20\x20\x20\x20\x20\x20</div>';
        if (f['error'])
            e += '\x0a\x20\x20\x20\x20\x20\x20\x20\x20<div\x20class=\x22message\x20error\x22\x20style=\x22background:\x20#fef2f2;\x20border-left:\x204px\x20solid\x20#ef4444;\x22>\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20<div\x20class=\x22message-role\x22\x20style=\x22color:\x20#dc2626;\x22>ERROR</div>\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20<div\x20class=\x22message-content\x22>Failed\x20to\x20fetch\x20conversation\x20details:\x20' + escapeHtml(f['error']) + '</div>\x0a\x20\x20\x20\x20\x20\x20\x20\x20</div>';
        else {
            if (f['mapping']) {
                const i = extractMessages(f);
                i['forEach'](j => {
                    e += '\x0a\x20\x20\x20\x20\x20\x20\x20\x20<div\x20class=\x22message\x20' + j['role'] + '\x22>\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20<div\x20class=\x22message-role\x22>' + (j['role'] === 'user' ? t('export.html.userRole') : t('export.html.assistantRole')) + '</div>\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20<div\x20class=\x22message-content\x22>' + escapeHtml(j['content']) + '</div>\x0a\x20\x20\x20\x20\x20\x20\x20\x20</div>';
                });
            }
        }
        e += '</div>';
    }), e += '\x0a</body>\x0a</html>', e;
}
function formatAsMarkdown(a) {
    const b = i18n['getCurrentLocale'](), c = new Date()['toLocaleString'](b === 'zh-CN' ? 'zh-CN' : b === 'zh-TW' ? 'zh-TW' : 'en-US');
    let d = t('export.markdown.title') + '\x0a\x0a';
    return d += t('export.markdown.exportTime', { 'time': c }) + '\x20\x20\x0a', d += t('export.markdown.conversationCount', { 'count': a['length'] }) + '\x0a\x0a', a['length'] > 0x1 && (d += t('export.markdown.tableOfContents') + '\x0a\x0a', a['forEach']((e, f) => {
        const g = e['title'] || t('ui.messages.noTitle');
        d += f + 0x1 + '.\x20[' + g + '](#' + (f + 0x1) + '-' + g['replace'](/[^a-zA-Z0-9\u4e00-\u9fa5]/g, '') + ')\x0a';
    }), d += '\x0a---\x0a\x0a'), a['forEach']((e, f) => {
        const g = e['title'] || t('ui.messages.noTitle');
        d += '##\x20' + (f + 0x1) + '.\x20' + g + '\x0a\x0a', d += t('export.markdown.conversationId', { 'id': e['conversation_id'] }) + '\x0a\x0a';
        if (e['error'])
            d += '###\x20❌\x20Error\x0a\x0a', d += 'Failed\x20to\x20fetch\x20conversation\x20details:\x20' + e['error'] + '\x0a\x0a';
        else {
            if (e['mapping']) {
                const h = extractMessages(e);
                h['forEach'](i => {
                    d += '###\x20' + (i['role'] === 'user' ? t('export.markdown.userRole') : t('export.markdown.assistantRole')) + '\x0a\x0a', d += i['content'] + '\x0a\x0a';
                });
            }
        }
        d += '---\x0a\x0a';
    }), d;
}
function formatAsText(a) {
    const b = i18n['getCurrentLocale'](), c = new Date()['toLocaleString'](b === 'zh-CN' ? 'zh-CN' : b === 'zh-TW' ? 'zh-TW' : 'en-US');
    let d = t('export.text.title') + '\x0a';
    return d += t('export.text.separator') + '\x0a', d += t('export.text.exportTime', { 'time': c }) + '\x0a', d += t('export.text.conversationCount', { 'count': a['length'] }) + '\x0a\x0a', a['forEach']((e, f) => {
        const g = e['title'] || t('ui.messages.noTitle');
        d += f + 0x1 + '.\x20' + g + '\x0a', d += t('export.text.conversationId', { 'id': e['conversation_id'] }) + '\x0a', d += t('export.text.divider') + '\x0a';
        if (e['error'])
            d += '\x0a[ERROR]\x0a', d += 'Failed\x20to\x20fetch\x20conversation\x20details:\x20' + e['error'] + '\x0a';
        else {
            if (e['mapping']) {
                const h = extractMessages(e);
                h['forEach'](i => {
                    d += '\x0a' + (i['role'] === 'user' ? t('export.text.userRole') : t('export.text.assistantRole')) + '\x0a', d += i['content'] + '\x0a';
                });
            }
        }
        d += '\x0a' + t('export.text.separator') + '\x0a\x0a';
    }), d;
}
function extractMessages(a) {
    const b = [];
    if (!a['mapping'])
        return b;
    let c = null;
    for (const [d, e] of Object['entries'](a['mapping'])) {
        if (!e['parent']) {
            c = d;
            break;
        }
    }
    while (c && a['mapping'][c]) {
        const f = a['mapping'][c];
        if (f['message'] && f['message']['content'] && f['message']['content']['parts']) {
            const h = f['message']['content']['parts']['join']('\x0a');
            h['trim']() && b['push']({
                'role': f['message']['author']['role'],
                'content': h['trim']()
            });
        }
        const g = f['children'] || [];
        c = g['length'] > 0x0 ? g[0x0] : null;
    }
    return b;
}
function escapeHtml(a) {
    const b = document['createElement']('div');
    return b['textContent'] = a, b['innerHTML'];
}
function updateI18nElements() {
    document['querySelectorAll']('[data-i18n]')['forEach'](a => {
        const b = a['getAttribute']('data-i18n'), c = t(b);
        if (a['tagName'] === 'OPTION')
            a['textContent'] = c;
        else
            a['tagName'] === 'INPUT' && a['type'] === 'text' ? a['placeholder'] = c : a['textContent'] = c;
    }), document['title'] = t('extensionName');
}
function setStatus(a, b = ![]) {
    const c = document['getElementById']('status');
    c['textContent'] = a, c['className'] = b ? 'status\x20loading' : 'status';
}
function showEmptyState() {
    document['getElementById']('conversationList')['style']['display'] = 'none', document['getElementById']('emptyState')['style']['display'] = 'block';
}
function hideEmptyState() {
    document['getElementById']('conversationList')['style']['display'] = 'block', document['getElementById']('emptyState')['style']['display'] = 'none';
}
function updateExportButton() {
    const a = document['querySelectorAll']('.conv-checkbox:checked'), b = document['getElementById']('export');
    b['disabled'] = a['length'] === 0x0;
}
function updateSelectAllButton() {
    const a = document['querySelectorAll']('.conv-checkbox'), b = document['querySelectorAll']('.conv-checkbox:checked'), c = document['getElementById']('selectAllText');
    if (a['length'] === 0x0)
        c['textContent'] = t('ui.buttons.selectAll');
    else {
        if (b['length'] === 0x0)
            c['textContent'] = t('ui.buttons.selectAll');
        else
            b['length'] === a['length'] ? c['textContent'] = t('ui.buttons.deselectAll') : c['textContent'] = t('ui.buttons.selectAll');
    }
}
function renderList(a) {
    const b = document['getElementById']('conversationList');
    b['innerHTML'] = '';
    if (a['length'] === 0x0) {
        showEmptyState();
        return;
    }
    hideEmptyState(), a['forEach']((c, d) => {
        const e = document['createElement']('div');
        e['className'] = 'conversation-item', e['style']['animationDelay'] = d * 0.05 + 's';
        const f = c['title'] || t('ui.messages.noTitle');
        e['innerHTML'] = '\x0a\x20\x20\x20\x20\x20\x20<input\x20type=\x22checkbox\x22\x20class=\x22conv-checkbox\x22\x20value=\x22' + c['id'] + '\x22>\x0a\x20\x20\x20\x20\x20\x20<div\x20class=\x22conversation-content\x22>\x0a\x20\x20\x20\x20\x20\x20\x20\x20<div\x20class=\x22conversation-title\x22\x20title=\x22' + f + '\x22>' + f + '</div>\x0a\x20\x20\x20\x20\x20\x20\x20\x20<div\x20class=\x22conversation-id\x22>' + c['id'] + '</div>\x0a\x20\x20\x20\x20\x20\x20</div>\x0a\x20\x20\x20\x20', e['addEventListener']('click', h => {
            if (h['target']['type'] !== 'checkbox') {
                const i = e['querySelector']('.conv-checkbox');
                i['checked'] = !i['checked'], updateUI();
            }
        });
        const g = e['querySelector']('.conv-checkbox');
        g['addEventListener']('change', updateUI), b['appendChild'](e);
    }), updateUI();
}
function updateUI() {
    updateExportButton(), updateSelectAllButton(), document['querySelectorAll']('.conversation-item')['forEach'](a => {
        const b = a['querySelector']('.conv-checkbox');
        b['checked'] ? a['classList']['add']('selected') : a['classList']['remove']('selected');
    });
}
async function refreshList() {
    setStatus(t('ui.status.loading'), !![]);
    try {
        const a = await fetchConversationsList();
        window['_convItems'] = a, renderList(a), setStatus(t('ui.messages.conversationCount', { 'count': a['length'] }));
    } catch (b) {
        setStatus(t('ui.status.loadFailed', { 'error': b['message'] })), showEmptyState();
    }
}
document['getElementById']('refresh')['onclick'] = refreshList, document['getElementById']('selectAll')['onclick'] = () => {
    const a = document['querySelectorAll']('.conv-checkbox'), b = document['querySelectorAll']('.conv-checkbox:checked');
    b['length'] === a['length'] ? a['forEach'](c => c['checked'] = ![]) : a['forEach'](c => c['checked'] = !![]), updateUI();
}, document['getElementById']('export')['onclick'] = async () => {
    const b = Array['from'](document['querySelectorAll']('.conv-checkbox:checked'));
    if (b['length'] === 0x0) {
        setStatus(t('ui.messages.selectAtLeastOne'));
        return;
    }
    document['querySelectorAll']('.btn')['forEach'](p => p['disabled'] = !![]), document['getElementById']('exportFormat')['disabled'] = !![], setStatus(t('ui.status.exporting'), !![]);
    const c = b['map'](p => p['value']), d = [];
    for (let p = 0x0; p < c['length']; p++) {
        setStatus(t('ui.messages.fetchingProgress', {
            'current': p + 0x1,
            'total': c['length']
        }), !![]);
        try {
            const q = await fetchConversationDetail(c[p]);
            d['push'](q);
        } catch (r) {
            const s = window['_convItems']?.['find'](u => u['id'] === c[p]), t = s ? s['title'] : 'Conversation\x20' + c[p];
            d['push']({
                'conversation_id': c[p],
                'title': t,
                'error': r['message']
            });
        }
    }
    const f = document['getElementById']('exportFormat')['value'], g = new Date()['toISOString']()['replace'](/[:.]/g, '-')['slice'](0x0, 0x13);
    let h, j, k;
    switch (f) {
    case 'html':
        h = formatAsHTML(d), j = 'text/html', k = 'html';
        break;
    case 'markdown':
        h = formatAsMarkdown(d), j = 'text/markdown', k = 'md';
        break;
    case 'text':
        h = formatAsText(d), j = 'text/plain', k = 'txt';
        break;
    case 'json':
    default:
        h = JSON['stringify'](d, null, 0x2), j = 'application/json', k = 'json';
        break;
    }
    const l = 'conversations_export_' + g + '.' + k, m = new Blob([h], { 'type': j }), n = URL['createObjectURL'](m), o = document['createElement']('a');
    o['href'] = n, o['download'] = l, o['click'](), URL['revokeObjectURL'](n), setStatus(t('ui.status.exportComplete', {
        'count': d['length'],
        'format': f['toUpperCase']()
    })), setTimeout(() => {
        window['close']();
    }, 0x3e8);
}, window['onload'] = async () => {
    await i18n['init'](), updateI18nElements(), setStatus(t('ui.status.ready')), refreshList();
};