class I18n {
    constructor() {
        this['currentLocale'] = 'en', this['messages'] = {}, this['fallbackLocale'] = 'en';
    }
    ['detectLocale']() {
        const a = navigator['language'] || navigator['userLanguage'], b = {
                'zh-CN': 'zh-CN',
                'zh-Hans': 'zh-CN',
                'zh': 'zh-CN',
                'zh-TW': 'zh-TW',
                'zh-Hant': 'zh-TW',
                'zh-HK': 'zh-TW',
                'zh-MO': 'zh-TW',
                'en': 'en',
                'en-US': 'en',
                'en-GB': 'en'
            };
        if (b[a])
            return b[a];
        const c = a['split']('-')[0x0];
        if (b[c])
            return b[c];
        return 'en';
    }
    async ['loadLocale'](a) {
        try {
            const b = await fetch('locales/' + a + '.json');
            if (!b['ok'])
                throw new Error('Failed\x20to\x20load\x20locale:\x20' + a);
            const c = await b['json']();
            return this['messages'][a] = c, !![];
        } catch (d) {
            return console['warn']('Failed\x20to\x20load\x20locale\x20' + a + ':', d), ![];
        }
    }
    async ['init']() {
        const a = this['detectLocale']();
        await this['loadLocale'](this['fallbackLocale']);
        if (a !== this['fallbackLocale']) {
            const b = await this['loadLocale'](a);
            b && (this['currentLocale'] = a);
        } else
            this['currentLocale'] = this['fallbackLocale'];
        console['log']('I18n\x20initialized\x20with\x20locale:\x20' + this['currentLocale']);
    }
    ['t'](a, b = {}) {
        const c = a['split']('.');
        let d = this['messages'][this['currentLocale']];
        for (const e of c) {
            if (d && typeof d === 'object' && e in d)
                d = d[e];
            else {
                d = null;
                break;
            }
        }
        if (d === null && this['currentLocale'] !== this['fallbackLocale']) {
            d = this['messages'][this['fallbackLocale']];
            for (const f of c) {
                if (d && typeof d === 'object' && f in d)
                    d = d[f];
                else {
                    d = null;
                    break;
                }
            }
        }
        if (d === null)
            return console['warn']('Translation\x20not\x20found\x20for\x20key:\x20' + a), a;
        if (typeof d !== 'string')
            return console['warn']('Translation\x20for\x20key\x20' + a + '\x20is\x20not\x20a\x20string:', d), a;
        return this['interpolate'](d, b);
    }
    ['interpolate'](a, b) {
        return a['replace'](/\{(\w+)\}/g, (c, d) => {
            return b['hasOwnProperty'](d) ? b[d] : c;
        });
    }
    ['getCurrentLocale']() {
        return this['currentLocale'];
    }
    async ['setLocale'](a) {
        if (this['messages'][a])
            return this['currentLocale'] = a, !![];
        const b = await this['loadLocale'](a);
        if (b)
            return this['currentLocale'] = a, !![];
        return ![];
    }
}
const i18n = new I18n();
function t(a, b) {
    return i18n['t'](a, b);
}
typeof window !== 'undefined' && (window['i18n'] = i18n, window['t'] = t);
typeof module !== 'undefined' && module['exports'] && (module['exports'] = {
    'i18n': i18n,
    't': t
});